/* File Table_modMain_Im.c */
/*
 ##############################################################
 # (C) 2013 BAE SYSTEMS
 #
 # ECOA Dining Philosophers Sample
 #
 # $Id: Table_modMain_Im.c,v 2.3 2017/11/06 15:33:40 ksappleb Exp $
 #
 # Part of the BAE Systems, Rochester, ECOA Samples collection
 #
 # Created by K S Appleby, BAE Systems, Airport Works, Rochester, Kent
 #
 # This software is developed for and on behalf of BAE Systems (Operations)
 # Limited, Dassault Aviation, Bull SAS, Thales Systemes Aeroportes,
 # GE Aviation Systems Limited,
 # General Dynamics United Kingdom Limited and Leonardo MW Ltd,
 # and the copyright is owned by BAE Systems (Operations) Limited,
 # Dassault Aviation, Bull SAS, Thales Systemes Aeroportes, 
 # GE Aviation Systems Limited, General Dynamics United Kingdom
 # Limited and Leonardo MW Ltd
 #
 # This software is developed by BAE Systems (Operations)
 # Limited, Electronic Systems, and is the Intellectual
 # Property of BAE Systems (Operations) Limited, Electronic Systems.
 #
 # The information set out in this document is provided solely
 # on an 'as is' basis and the co-developers of this software make
 # no warranties expressed or implied, including no warranties
 # as to completeness, accuracy or fitness for purpose, with respect
 # to any of the information.
 ##############################################################
*/
#include "Table_modMain_Im.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

/* Runtime lifecycle API */
void Table_modMain_Im__INITIALIZE__received
   (Table_modMain_Im__context* context)
{
	int i;
	for( i = 0; i < 5; i++ ){
		context->user.Stick[i] = FREE;
	}
}

void Table_modMain_Im__START__received
   (Table_modMain_Im__context* context)
{
	ECOA__log msg;
	Table_modMain_Im_container__ready_handle rdyHndl;
	//
	msg.current_size = sprintf( msg.data, "\n\tThe Table is laid, the chopsticks are available...\n" );
	Table_modMain_Im_container__log_info( context, msg );
	//
	Table_modMain_Im_container__ready__get_write_access( context, &rdyHndl );
	*(rdyHndl.data) = ECOA__TRUE;
	Table_modMain_Im_container__ready__publish_write_access( context, &rdyHndl );
}

void Table_modMain_Im__STOP__received
   (Table_modMain_Im__context* context)
{
   /* User Code Here */
}

void Table_modMain_Im__SHUTDOWN__received
   (Table_modMain_Im__context* context)
{
   /* User Code Here */
}

void Table_modMain_Im__take__request_received
   (Table_modMain_Im__context* context,
    const ECOA__uint32 ID,
    const ECOA__int32 which,
    const ECOA__int32 who)
{
	ECOA__boolean8 taken = 0;
	//
	if( context->user.Stick[which] == FREE ){
		taken = ECOA__TRUE;
		context->user.Stick[which] = who;
//		fprintf( stderr, "chopstick %d taken by %d...\n", which, who );
	}else{
		taken = ECOA__FALSE;
//		fprintf( stderr, "chopstick %d requested by %d busy...\n", which, who );
	}
	Table_modMain_Im_container__take__response_send( context, ID, taken );
}

void Table_modMain_Im__surrender__request_received
   (Table_modMain_Im__context* context,
    const ECOA__uint32 ID,
    const ECOA__int32 which,
    const ECOA__int32 who)
{
	if( context->user.Stick[which] != who ){
		errno = EPERM; perror( "surrender" );
		fprintf( stderr, "%d is trying to surrender chopstick %d held by %d...\n", who, which, context->user.Stick[which] );
		exit(4);
	}else{
		context->user.Stick[which] = FREE;
	}
	// Stupid, non-function that must be called...
	Table_modMain_Im_container__surrender__response_send( context, ID ); // There is no response !! But this MUST be called....
//	fprintf( stderr, "chopstick %d surrendered by %d...\n", which, who );
}
