/* ELI Message definition */

#ifndef ELI_HEADER_H_
#define ELI_HEADER_H_

#include "ECOA.h"

typedef ECOA__uint8 ELI_Message__Version;
#define ELI_Message__Version_Number (2)

typedef ECOA__uint8 ELI_Message__Domain;
#define ELI_Message__Domain_PLATFORM (0)
#define ELI_Message__Domain_SERVICE_OP (1)
#define ELI_Message__Domain_PROTECTION_DOMAIN (2)

typedef ECOA__int32 ELI_Message__PlatformMessageID;
#define ELI_Message__PlatformMessageID_PLATFORM_STATUS (1)
#define ELI_Message__PlatformMessageID_PLATFORM_STATUS_REQUEST (2)
#define ELI_Message__PlatformMessageID_UNKNOWN_OPERATION (3)
#define ELI_Message__PlatformMessageID_VERSIONED_DATA_PULL (4)
#define ELI_Message__PlatformMessageID_DEPLOYMENT_CHANGE_REQUEST (5)
#define ELI_Message__PlatformMessageID_DEPLOYMENT_CHANGE_REQUEST_ACK (6)

typedef struct
{
   ECOA__uint16 ecoaMark;
   ELI_Message__Version version;
   ELI_Message__Domain domain;
   ECOA__uint32 logicalPlatform;
   ECOA__uint32 ID;
   ECOA__uint32 payloadSize;
   ECOA__uint32 sequenceNumber;
} ELIHeader;

typedef ECOA__uint32 ELI_Message__PlatformStatus;
#define ELI_Message__PlatformStatus_DOWN (0)
#define ELI_Message__PlatformStatus_UP (1)

typedef struct
{
   ELI_Message__PlatformStatus status;
   ECOA__uint32 deploymentID;
} PlatformStatus;
typedef struct
{
   ECOA__uint32 deploymentID;
} DeploymentChangeRequest;
typedef struct
{
   ECOA__uint32 status;
} DeploymentChangeRequestAck;
typedef struct
{
   ECOA__uint32 euid;
} VersionedDataPull;
typedef struct
{
   ECOA__uint32 euid;
} UnknownOperation;

typedef union
{
   PlatformStatus platformStatus;
   /* No params for PlatformStatusRequest */
   DeploymentChangeRequest deploymentChangeRequest;
   DeploymentChangeRequestAck deploymentChangeRequestAck;
   VersionedDataPull versionedDataPull;
   UnknownOperation unknownOperation;
} PlatformELIPayload;

#endif /* ELI_HEADER_H_ */
