with Ada.Unchecked_Conversion;
with System;

package ECOA is

   subtype Boolean_8_Type is Boolean;

   subtype Character_8_Type is Character
     range Character'Val(0) .. Character'Val(127);

   type Signed_8_Type is range -2 ** 7 + 1 .. 2 ** 7 - 1;
   for Signed_8_Type'Size use 8;
   for Signed_8_Type'Alignment use 1;

   type Signed_16_Type is range -2 ** 15 + 1 .. 2 ** 15 - 1;
   for Signed_16_Type'Size use 16;
   for Signed_16_Type'Alignment use 2;

   type Signed_32_Type is range -2 ** 31 + 1 .. 2 ** 31 - 1;
   for Signed_32_Type'Size use 32;
   for Signed_32_Type'Alignment use 4;

   type Signed_64_Type is range -2 ** 63 + 1 .. 2 ** 63 - 1;
   for Signed_64_Type'Size use 64;
   for Signed_64_Type'Alignment use 8;

   type Unsigned_8_Type is mod 2 ** 8;
   for Unsigned_8_Type'Size use 8;
   for Unsigned_8_Type'Alignment use 1;

   type Unsigned_16_Type is mod 2 ** 16;
   for Unsigned_16_Type'Size use 16;
   for Unsigned_16_Type'Alignment use 2;

   type Unsigned_32_Type is mod 2 ** 32;
   for Unsigned_32_Type'Size use 32;
   for Unsigned_32_Type'Alignment use 4;

   type Unsigned_64_Type is mod 2 ** 64;
   for Unsigned_64_Type'Size use 64;
   for Unsigned_64_Type'Alignment use 8;

   type Float_32_Type is digits 6 range -3.402823466e+38 .. 3.402823466e+38;
   for Float_32_Type'Size use 32;
   for Float_32_Type'Alignment use 4;

   type Float_64_Type is digits 15 range -1.7976931348623157e+308 ..
     1.7976931348623157e+308;
   for Float_64_Type'Size use 64;
   for Float_64_Type'Alignment use 8;

   type Byte_8_Type is mod 2 ** 8;
   for Byte_8_Type'Size use 8;
   for Byte_8_Type'Alignment use 1;

   type Response_Received_Return_Status_Type is
     (Response_Received_Return_Status_Type_OK,
      Response_Received_Return_Status_Type_NO_RESPONSE);
   for Response_Received_Return_Status_Type use
     (Response_Received_Return_Status_Type_OK          => 0,
      Response_Received_Return_Status_Type_NO_RESPONSE => 5);
   for Response_Received_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Response_Received_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Request_Sync_Return_Status_Type is
     (Request_Sync_Return_Status_Type_OK,
      Request_Sync_Return_Status_Type_NO_RESPONSE);
   for Request_Sync_Return_Status_Type use
     (Request_Sync_Return_Status_Type_OK          => 0,
      Request_Sync_Return_Status_Type_NO_RESPONSE => 5);
   for Request_Sync_Return_Status_Type'Size use Unsigned_32_Type'Size;
   for Request_Sync_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Request_Async_Return_Status_Type is
      (Request_Async_Return_Status_Type_OK,
       Request_Async_Return_Status_Type_RESOURCE_NOT_AVAILABLE);
   for Request_Async_Return_Status_Type use
      (Request_Async_Return_Status_Type_OK                    => 0,
       Request_Async_Return_Status_Type_RESOURCE_NOT_AVAILABLE => 8);
   for Request_Async_Return_Status_Type'Size use Unsigned_32_Type'Size;
   for Request_Async_Return_Status_Type'Alignment use
     Unsigned_32_Type'Alignment;

   type Response_Send_Return_Status_Type is
     (Response_Send_Return_Status_Type_OK,
      Response_Send_Return_Status_Type_INVALID_IDENTIFIER);
   for Response_Send_Return_Status_Type use
     (Response_Send_Return_Status_Type_OK                 => 0,
      Response_Send_Return_Status_Type_INVALID_IDENTIFIER => 4);
   for Response_Send_Return_Status_Type'Size use Unsigned_32_Type'Size;
   for Response_Send_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Get_Read_Access_Return_Status_Type is
     (Get_Read_Access_Return_Status_Type_OK,
      Get_Read_Access_Return_Status_Type_INVALID_HANDLE,
      Get_Read_Access_Return_Status_Type_NO_DATA,
      Get_Read_Access_Return_Status_Type_RESOURCE_NOT_AVAILABLE);
   for Get_Read_Access_Return_Status_Type use
     (Get_Read_Access_Return_Status_Type_OK                     => 0,
      Get_Read_Access_Return_Status_Type_INVALID_HANDLE         => 1,
      Get_Read_Access_Return_Status_Type_NO_DATA                => 3,
      Get_Read_Access_Return_Status_Type_RESOURCE_NOT_AVAILABLE => 10);
   for Get_Read_Access_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Get_Read_Access_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Release_Read_Access_Return_Status_Type is
     (Release_Read_Access_Return_Status_Type_OK,
      Release_Read_Access_Return_Status_Type_INVALID_HANDLE);
   for Release_Read_Access_Return_Status_Type use
     (Release_Read_Access_Return_Status_Type_OK             => 0,
      Release_Read_Access_Return_Status_Type_INVALID_HANDLE => 1);
   for Release_Read_Access_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Release_Read_Access_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Get_Write_Access_Return_Status_Type is
     (Get_Write_Access_Return_Status_Type_OK,
      Get_Write_Access_Return_Status_Type_INVALID_HANDLE,
      Get_Write_Access_Return_Status_Type_DATA_NOT_INITIALIZED,
      Get_Write_Access_Return_Status_Type_RESOURCE_NOT_AVAILABLE);
   for Get_Write_Access_Return_Status_Type use
     (Get_Write_Access_Return_Status_Type_OK                     => 0,
      Get_Write_Access_Return_Status_Type_INVALID_HANDLE         => 1,
      Get_Write_Access_Return_Status_Type_DATA_NOT_INITIALIZED   => 2,
      Get_Write_Access_Return_Status_Type_RESOURCE_NOT_AVAILABLE => 10);
   for Get_Write_Access_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Get_Write_Access_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Cancel_Write_Access_Return_Status_Type is
     (Cancel_Write_Access_Return_Status_Type_OK,
      Cancel_Write_Access_Return_Status_Type_INVALID_HANDLE);
   for Cancel_Write_Access_Return_Status_Type use
     (Cancel_Write_Access_Return_Status_Type_OK             => 0,
      Cancel_Write_Access_Return_Status_Type_INVALID_HANDLE => 1);
   for Cancel_Write_Access_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Cancel_Write_Access_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Publish_Write_Access_Return_Status_Type is
     (Publish_Write_Access_Return_Status_Type_OK,
      Publish_Write_Access_Return_Status_Type_INVALID_HANDLE);
   for Publish_Write_Access_Return_Status_Type use
     (Publish_Write_Access_Return_Status_Type_OK             => 0,
      Publish_Write_Access_Return_Status_Type_INVALID_HANDLE => 1);
   for Publish_Write_Access_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Publish_Write_Access_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Get_UTC_Time_Return_Status_Type is
     (Get_UTC_Time_Return_Status_Type_OK,
      Get_UTC_Time_Return_Status_Type_CLOCK_UNSYNCHRONIZED);
   for Get_UTC_Time_Return_Status_Type use
     (Get_UTC_Time_Return_Status_Type_OK                   => 0,
      Get_UTC_Time_Return_Status_Type_CLOCK_UNSYNCHRONIZED => 8);
   for Get_UTC_Time_Return_Status_Type'Size use Unsigned_32_Type'Size;
   for Get_UTC_Time_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Get_Absolute_System_Time_Return_Status_Type is
     (Get_Absolute_System_Time_Return_Status_Type_OK,
      Get_Absolute_System_Time_Return_Status_Type_CLOCK_UNSYNCHRONIZED);
   for Get_Absolute_System_Time_Return_Status_Type use
     (Get_Absolute_System_Time_Return_Status_Type_OK
        => 0,
      Get_Absolute_System_Time_Return_Status_Type_CLOCK_UNSYNCHRONIZED
        => 8);
   for Get_Absolute_System_Time_Return_Status_Type'Size
     use Unsigned_32_Type'Size;
   for Get_Absolute_System_Time_Return_Status_Type'Alignment
     use Unsigned_32_Type'Alignment;

   type Recovery_Action_Return_Status_Type is
      (Recovery_Action_Return_Status_Type_OK,
       Recovery_Action_Return_Status_Type_INVALID_IDENTIFIER,
       Recovery_Action_Return_Status_Type_OPERATION_ALREADY_PENDING,
       Recovery_Action_Return_Status_Type_OPERATION_NOT_AVAILABLE);
   for Recovery_Action_Return_Status_Type use
      (Recovery_Action_Return_Status_Type_OK
         => 0,
       Recovery_Action_Return_Status_Type_INVALID_IDENTIFIER
         => 4,
       Recovery_Action_Return_Status_Type_OPERATION_ALREADY_PENDING
         => 6,
       Recovery_Action_Return_Status_Type_OPERATION_NOT_AVAILABLE
         => 11);
   for Recovery_Action_Return_Status_Type'Size use
     Unsigned_32_Type'Size;
   for Recovery_Action_Return_Status_Type'Alignment use
     Unsigned_32_Type'Alignment;

   type Read_Return_Status_Type is
      (Read_Return_Status_Type_OK,
       Read_Return_Status_Type_RESOURCE_NOT_AVAILABLE,
       Read_Return_Status_Type_INVALID_PARAMETER);
   for Read_Return_Status_Type use
      (Read_Return_Status_Type_OK
         => 0,
       Read_Return_Status_Type_RESOURCE_NOT_AVAILABLE
         => 10,
       Read_Return_Status_Type_INVALID_PARAMETER
         => 13);
   for Read_Return_Status_Type'Size use
     Unsigned_32_Type'Size;
   for Read_Return_Status_Type'Alignment use
     Unsigned_32_Type'Alignment;

   type Seek_Return_Status_Type is
      (Seek_Return_Status_Type_OK,
       Seek_Return_Status_Type_RESOURCE_NOT_AVAILABLE,
       Seek_Return_Status_Type_INVALID_PARAMETER);
   for Seek_Return_Status_Type use
      (Seek_Return_Status_Type_OK
         => 0,
       Seek_Return_Status_Type_RESOURCE_NOT_AVAILABLE
         => 10,
       Seek_Return_Status_Type_INVALID_PARAMETER
         => 13);
   for Seek_Return_Status_Type'Size use Unsigned_32_Type'Size;
   for Seek_Return_Status_Type'Alignment use
     Unsigned_32_Type'Alignment;

   type Seconds_Type is mod 2 ** 32;
   for Seconds_Type'Size use 32;
   for Seconds_Type'Alignment use 4;

   type Nanoseconds_Type is range 0 .. 10 ** 9 - 1;
   for Nanoseconds_Type'Size use 32;
   for Nanoseconds_Type'Alignment use 4;

   type HR_Time_Type is
      record
         Seconds     : Seconds_Type;
         Nanoseconds : Nanoseconds_Type;
      end record;
   for HR_Time_Type'Size use 64;
   for HR_Time_Type'Alignment use 4;

   type Global_Time_Type is
      record
         Seconds     : Seconds_Type;
         Nanoseconds : Nanoseconds_Type;
      end record;
   for Global_Time_Type'Size use 64;
   for Global_Time_Type'Alignment use 4;

   type Duration_Type is record
      Seconds     : Seconds_Type;
      Nanoseconds : Nanoseconds_Type;
   end record;
   for Duration_Type'Size use 64;
   for Duration_Type'Alignment use 4;

   type Log_Elements_Size_Type is range 0..256;
   for Log_Elements_Size_Type'Size use 32;
   for Log_Elements_Size_Type'Alignment use 4;
   subtype Log_Elements_Index_Type is Log_Elements_Size_Type range 0..255;

   type Log_Elements_Type is array (Log_Elements_Index_Type) of
     Character_8_Type;
   for Log_Elements_Type'Size use 2048;
   for Log_Elements_Type'Alignment use 4;

   type Log_Type is
      record
         Current_Size : Log_Elements_Size_Type;
         Data         : Log_Elements_Type;
      end record;
   for Log_Type'Size use 2080;
   for Log_Type'Alignment use 4;

   subtype Error_ID_Type is Unsigned_32_Type
     range Unsigned_32_Type'First .. Unsigned_32_Type'Last;

   subtype Asset_ID_Type is Unsigned_32_Type
     range Unsigned_32_Type'First .. Unsigned_32_Type'Last;

   type Asset_Type is
     (Asset_Type_COMPONENT,
      Asset_Type_PROTECTION_DOMAIN,
      Asset_Type_NODE,
      Asset_Type_PLATFORM,
      Asset_Type_SERVICE,
      Asset_Type_DEPLOYMENT);
   for Asset_Type use
     (Asset_Type_COMPONENT         => 0,
      Asset_Type_PROTECTION_DOMAIN => 1,
      Asset_Type_NODE              => 2,
      Asset_Type_PLATFORM          => 3,
      Asset_Type_SERVICE           => 4,
      Asset_Type_DEPLOYMENT        => 5);
   for Asset_Type'Size use 32;
   for Asset_Type'Alignment use 4;

   type Error_Type is
     (Error_Type_RESOURCE_NOT_AVAILABLE,
      Error_Type_UNAVAILABLE,
      Error_Type_MEMORY_VIOLATION,
      Error_Type_NUMERICAL_ERROR,
      Error_Type_ILLEGAL_INSTRUCTION,
      Error_Type_STACK_OVERFLOW,
      Error_Type_DEADLINE_VIOLATION,
      Error_Type_OVERFLOW,
      Error_Type_UNDERFLOW,
      Error_Type_ILLEGAL_INPUT_ARGS,
      Error_Type_ILLEGAL_OUTPUT_ARGS,
      Error_Type_ERROR,
      Error_Type_FATAL_ERROR,
      Error_Type_HARDWARE_FAULT,
      Error_Type_POWER_FAIL,
      Error_Type_COMMUNICATION_ERROR,
      Error_Type_INVALID_CONFIG,
      Error_Type_INITIALISATION_PROBLEM,
      Error_Type_CLOCK_UNSYNCHRONIZED,
      Error_Type_UNKNOWN_OPERATION,
      Error_Type_OPERATION_OVERRATED,
      Error_Type_OPERATION_UNDERRATED);
   for Error_Type use
     (Error_Type_RESOURCE_NOT_AVAILABLE =>  0,
      Error_Type_UNAVAILABLE            =>  1,
      Error_Type_MEMORY_VIOLATION       =>  2,
      Error_Type_NUMERICAL_ERROR        =>  3,
      Error_Type_ILLEGAL_INSTRUCTION    =>  4,
      Error_Type_STACK_OVERFLOW         =>  5,
      Error_Type_DEADLINE_VIOLATION     =>  6,
      Error_Type_OVERFLOW               =>  7,
      Error_Type_UNDERFLOW              =>  8,
      Error_Type_ILLEGAL_INPUT_ARGS     =>  9,
      Error_Type_ILLEGAL_OUTPUT_ARGS    => 10,
      Error_Type_ERROR                  => 11,
      Error_Type_FATAL_ERROR            => 12,
      Error_Type_HARDWARE_FAULT         => 13,
      Error_Type_POWER_FAIL             => 14,
      Error_Type_COMMUNICATION_ERROR    => 15,
      Error_Type_INVALID_CONFIG         => 16,
      Error_Type_INITIALISATION_PROBLEM => 17,
      Error_Type_CLOCK_UNSYNCHRONIZED   => 18,
      Error_Type_UNKNOWN_OPERATION      => 19,
      Error_Type_OPERATION_OVERRATED    => 20,
      Error_Type_OPERATION_UNDERRATED   => 21);
   for Error_Type'Size use 32;
   for Error_Type'Alignment use 4;

   type Recovery_Action_Type is
     (Recovery_Action_Type_SHUTDOWN,
      Recovery_Action_Type_COLD_RESTART,
      Recovery_Action_Type_WARM_RESTART,
      Recovery_Action_Type_CHANGE_DEPLOYMENT);
   for Recovery_Action_Type use
     (Recovery_Action_Type_SHUTDOWN          => 0,
      Recovery_Action_Type_COLD_RESTART      => 1,
      Recovery_Action_Type_WARM_RESTART      => 2,
      Recovery_Action_Type_CHANGE_DEPLOYMENT => 3);
   for Recovery_Action_Type'Size use 32;
   for Recovery_Action_Type'Alignment use 4;

   type PINFO_Filename_Elements_Size_Type is range 0..256;
   for PINFO_Filename_Elements_Size_Type'Size use 32;
   for PINFO_Filename_Elements_Size_Type'Alignment use 4;
   subtype PINFO_Filename_Elements_Index_Type is
     PINFO_Filename_Elements_Size_Type range 0..255;

   type PINFO_Filename_Elements_Type is
     array (PINFO_Filename_Elements_Index_Type) of Character_8_Type;
   for PINFO_Filename_Elements_Type'Size use 2048;
   for PINFO_Filename_Elements_Type'Alignment use 4;

   type PINFO_Filename_Type is
      record
         Current_Size : PINFO_Filename_Elements_Size_Type;
         Data         : PINFO_Filename_Elements_Type;
      end record;
   for PINFO_Filename_Type'Size use 2080;
   for PINFO_Filename_Type'Alignment use 4;

   type Seek_Whence_Type is
      (Seek_Whence_Type_SEEK_SET,
       Seek_Whence_Type_SEEK_CUR,
       Seek_Whence_Type_SEEK_END);
   for Seek_Whence_Type use
      (Seek_Whence_Type_SEEK_SET => 0,
       Seek_Whence_Type_SEEK_CUR => 1,
       Seek_Whence_Type_SEEK_END => 2);
   for Seek_Whence_Type'Size use Unsigned_32_Type'Size;
   for Seek_Whence_Type'Alignment use Unsigned_32_Type'Alignment;

   type Request_Response_ID_Type is mod 2 ** 32;
   for Request_Response_ID_Type'Size use 32;
   for Request_Response_ID_Type'Alignment use 4;

   type PINFO_Size_Type is mod 2 ** 32;
   for PINFO_Size_Type'Size use 32;
   for PINFO_Size_Type'Alignment use 4;

   type PINFO_Offset_Type is range -2 ** 31 + 1  .. 2 ** 31 - 1;
   for PINFO_Offset_Type'Size use 32;
   for PINFO_Offset_Type'Alignment use 4;
   
   type PINFO_Position_Type is mod 2 ** 32;
   for PINFO_Position_Type'Size use 32;
   for PINFO_Position_Type'Alignment use 4;
   
   type System_Address_Type is private;

   Default_System_Address : constant System_Address_Type;

   private
      --# hide ECOA;
      type System_Address_Type is new System.Address;

      function To_System_Address is new
        Ada.Unchecked_Conversion(System.Address, System_Address_Type);

      Default_System_Address : constant System_Address_Type :=
        To_System_Address(System.Null_Address);
 
end ECOA;
