// ---------------------------------------------------------------------
//      Copyright  (c) (Date as Issue), BAE Systems.
//      All rights reserved.
//
// Department : IMS OSL Project,
//              Hawk Mission Systems,
//              Brough,
//              East Yorkshire,
//              England,
//              HU15 1EQ
//
// Revision History :
//
// Date       Author          Description
// ----       ------          -----------
// 11/10/04   J.R.Stones      Original version.
// 12/07/06   P.R.Miller      BAE-BSY-RM-HWK-005103: correcting coding
//                            standards non-conformance issues.
// 08/05/12   D.Clarke        BAE-BSY-PR-IMS-170: Added MAX_SECONDS and
//                            MAX_NANOSECONDS constants.
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
//
// OSL_Constants
//
// Purpose :
//    The OSL_Constants defines the list of constants, which are related
//    to the OSL. This avoids the duplication of the definition of these
//    constants and allows changes to be scoped to one package, so that
//    consistency is achieved across the OSL.
//
//    This file is a copy of the its Ada95 counterpart, except that only
//    those values require for this C implementation of the APOS
//    interface have been specified.
//
// Effects :
//    This package is used to constrain the type declarations used
//    within the OSL. These are specific to the OSL and should only
//    be changed, if the implementation of the OSL changes as well.
//
// Performance :
//    Not applicable.
//
// Safety-Criticality :
//    This software is implemented to Safety Integrity Level 3.
//
// ---------------------------------------------------------------------

#ifndef OSL_CONSTANTS_INCLUDED
#define OSL_CONSTANTS_INCLUDED

// ---------------------------------------------------------------------

// Defines the maximum length of a GSM identifier header.
#define MAX_LENGTH_OF_GSM_ID_HEADER 5

// Defines the maximum length of a partition header.
#define MAX_LENGTH_OF_PARTITION_HEADER 1

// Defines the maximum length of a process identifier header.
#define MAX_LENGTH_OF_PROCESS_ID_HEADER 4

// Defines the maximum length of a time header.
#define MAX_LENGTH_OF_TIME_HEADER 9

// Defines the maximum length of an APOS log entry header.
#define MAX_LENGTH_OF_APOS_LOG_ENTRY_HEADER MAX_LENGTH_OF_GSM_ID_HEADER + MAX_LENGTH_OF_PARTITION_HEADER + MAX_LENGTH_OF_PROCESS_ID_HEADER + MAX_LENGTH_OF_TIME_HEADER

// Defines the maximum number of nanoseconds.
#define MAX_NANOSECONDS 999999999

// Defines the maximum number of seconds.
#define MAX_SECONDS 2147483647
// ---------------------------------------------------------------------

#endif
