/* File posix_apos_binding.h */
/* This is the Posix-APOS binding */

#if !defined(POSIX_APOS_BINDING_H)
#define POSIX_APOS_BINDING_H


#include "osl004_apos.h"
#if defined( VXW )
  /* VxWorks is picky, and doesn't include some prototypes in the POSIX headers... */
#include <sockLib.h>
#include <inetLib.h>
#endif

void Receive_Message_POSIX
   (int            VC_ID,
    void           *Msg_Buffer,
    int            Msg_Length_Available,
    Time_Type      Timeout,
    int            *Msg_Length,
    RM_Status_Type *Status);

void Send_Message_Non_Blocking_POSIX
   (int              vc_id,
    void             *Msg_Buffer,
    int              Msg_Length,
    SMNB_Status_Type *Status);
 
void posix_apos_binding__Initialise();


#endif  /* POSIX_APOS_BINDING_H */


