// ---------------------------------------------------------------------
// This is an unpublished work created in 2004, any copyright in which
// vests in BAE SYSTEMS. All rights reserved. The information contained
// in this record is proprietary to BAE SYSTEMS unless stated otherwise
// and is made available in confidence; it must not be used or disclosed
// without the express written consent of BAE SYSTEMS which may be given
// by contract.
//
// Department : Software Architectures Team,
//              Mission Systems,
//              Brough,
//              East Yorkshire,
//              England,
//              HU15 1EQ
//
// Revision History :
//
// Date       Author          Description
// ----       ------          -----------
// 11/10/04   J.R.Stones      Original version.
// 11/05/07   P.Moxon         Added invalid parameter enumeration for
//                            Receive_Message.
// 29/11/07   P.R.Miller      Added Invalid_Receive_Blocking_Timeout
//                            enumeration to RM_Status_Enum.
// 03/06/10   K.Jones         PR-IMS-33:Added Received_No_Blocking_Data
// 16/11/10   K.Jones         Updated to Cap3
// 30/11/10   D.Clarke        Added types used by the APOS Mass Store services
// 05/04/11   P.R.Miller      BAE-BSY-PR-IMS-80: Added types for
//                            supporting event handling. Corrected
//                            header.
// 22/07/11   J.Hudson        BAE-BSY-PR-IMS-122: added Wait_On_Multi_Channel
//                            service and
//                            BAE-BSY-PR-IMS-123: Errors in C/C++ bindings.
//                            header.
// 23/08/11   R.Payne         BAE-BSY-PR-IMS-133: added types for missing timer operations
// 22/09/11   P.R.Miller      BAE-BSY-PR-IMS-127: Added new 'Failed'
//                            status enum to several types.
// 10/10/11   J.Hudson        BAE-BSY-PR-IMS-135: changed types to match
//                            IRS.
// 04/10/12   D.Clarke        BAE-BSY-PR-IMS-170: changed #include to osl003*
// 26/09/13   D.Clarke        BAE-BSY-PR-IMS-341: Changed name of size_t
//                            and ssize_t.
// 22/01/15   P.R.Miller      BAE-BSY-PR-IMS-576: Updated from IMS
//                            Capabilty 3 to include Capability 4
//                            functionality - removed file services
//                            related types.
// 08/06/16   P.R.Miller      BAE-BSY-PR-IMS-648: Added types in support
//                            of new Mutex related services. Also
//                            removed 'Failed' enum's from Semaphore
//                            Status types.
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
//
// APOS_Types
//
// Purpose :
//    This APOS_Types contains all of the types associated with the
//    APOS. The comments describe name conventions used in the APOS IRS.
//
// Effects :
//    None.
//
// Performance :
//    Not applicable.
//
// Safety-Criticality :
//    This software is implemented to Safety Integrity Level 3.
//
// ---------------------------------------------------------------------

#ifndef APOS_TYPES_INCLUDED
#define APOS_TYPES_INCLUDED

// ---------------------------------------------------------------------

#include "osl003_compile_constants.h"
#include "osl003_osl_constants.h"

// ---------------------------------------------------------------------
// Constant Definitions
// ---------------------------------------------------------------------

// Defines the maximum length of a log entry.
#define MAX_LENGTH_OF_APOS_LOG_ENTRY MAX_LENGTH_OF_LOG_ENTRY - MAX_LENGTH_OF_APOS_LOG_ENTRY_HEADER

// Defines the maximum number of VCs in the VC Sets used by Wait_On_Multi_Channel.
#define MAX_NUMBER_OF_APOS_WOMC_VCS MAX_NUMBER_OF_WOMC_VCS

// ---------------------------------------------------------------------
// Type Definitions
// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when logging an error.
// IRS Name : Log_Error_Status_Type
enum LE_Status_Enum
{
   Log_Error_OK,               // IRS Name : Log_Error_OK
   Log_Error_Not_Time_Stamped, // IRS Name : Log_Error_Not_Time_Stamped
   Log_Error_Overflow,         // IRS Name : Log_Error_Overflow
   Invalid_Log_Error_Param     // IRS Name : Not Required in IRS
};

typedef enum LE_Status_Enum LE_Status_Type;

// ---------------------------------------------------------------------

// Defines the log entry.
// IRS Name : Log_Entry_Type
typedef unsigned char Log_Entry_Type[MAX_LENGTH_OF_APOS_LOG_ENTRY];

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when raising an application error.
// IRS Name : Raise_Application_Error_Status_Type
enum RAE_Status_Enum
{
   Raise_Application_Error_OK,               // IRS Name : Raise_Application_Error_OK
   Raise_Application_Error_Not_Time_Stamped, // IRS Name : Raise_Application_Error_Not_Time_Stamped
   Raise_Application_Error_Overflow,         // IRS Name : Raise_Application_Error_Overflow
   Invalid_Raise_Application_Error_Code,     // IRS Name : Raise_Application_Invalid_Error_Code
   Invalid_Raise_Application_Error_Param     // IRS Name : Not Required in IRS
};

typedef enum RAE_Status_Enum RAE_Status_Type;

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when receiving a message that is non-blocking.
// IRS Name : Comms_Status_Type
enum RMNB_Status_Enum
{
   Non_Blocking_Message_Received_OK,          // IRS Name : Comms_OK
   Received_No_Non_Blocking_Data,             // IRS Name : Comms_No_Data
   Received_Non_Blocking_Buffer_Overflow,     // IRS Name : Comms_Buffer_Overflow
   Invalid_Receive_Non_Blocking_VC,           // IRS Name : Comms_Invalid_VC
   Invalid_Receive_Non_Blocking_Buffer,       // IRS Name : Comms_Invalid_Buffer
   Invalid_Receive_Non_Blocking_Length,       // IRS Name : Comms_Invalid_Length
   Receive_Non_Blocking_Comms_Failure,        // IRS Name : Not Required in IRS
   Invalid_Receive_Message_Non_Blocking_Param // IRS Name : Not Required in IRS
};

typedef enum RMNB_Status_Enum RMNB_Status_Type;

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when receiving a message that is blocking.
// IRS Name : Comms_Status_Type
enum RM_Status_Enum
{
    Blocking_Message_Received_OK,
    Received_Blocking_Buffer_Overflow,
    Received_Blocking_Timeout,
    Invalid_Receive_Blocking_VC,
    Invalid_Receive_Blocking_Buffer,
    Invalid_Receive_Blocking_Length,
    Invalid_Receive_Blocking_Timeout,
    Receive_Blocking_Comms_Failure,
    Receive_Blocking_Timer_Failure,
    Invalid_Receive_Message_Param
};

typedef enum RM_Status_Enum RM_Status_Type;

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when sending a message that is non-blocking.
// IRS Name : Comms_Status_Type
enum SMNB_Status_Enum
{
   Non_Blocking_Message_Sent_OK,           // IRS Name : Comms_OK
   Invalid_Send_Non_Blocking_VC,           // IRS Name : Comms_Invalid_VC
   Invalid_Send_Non_Blocking_Buffer,       // IRS Name : Comms_Invalid_Buffer
   Invalid_Send_Non_Blocking_Length,       // IRS Name : Comms_Invalid_Length
   Send_Non_Blocking_Comms_Failure,        // IRS Name : Not Required in IRS
   Send_Non_Blocking_Buffer_Unavailable,
   Invalid_Send_Message_Non_Blocking_Param // IRS Name : Not Required in IRS
};

typedef enum SMNB_Status_Enum SMNB_Status_Type;

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when sending a message that is blocking.
// IRS Name : Comms_Status_Type
enum SM_Status_Enum
{
   Blocking_Message_Sent_OK,           // IRS Name : Comms_OK
   Invalid_Send_Blocking_VC,           // IRS Name : Comms_Invalid_VC
   Invalid_Send_Blocking_Buffer,       // IRS Name : Comms_Invalid_Buffer
   Invalid_Send_Blocking_Length,       // IRS Name : Comms_Invalid_Length
   Send_Blocking_Comms_Failure,        // IRS Name :
   Invalid_Send_Blocking_Timeout,      // IRS Name :
   Send_Blocking_Timer_Failure,        // IRS Name :
   Send_Blocking_Timeout,              // IRS Name :
   Invalid_Send_Message_Blocking_Param // IRS Name : Not Required in IRS
};

typedef enum SM_Status_Enum SM_Status_Type;

// ---------------------------------------------------------------------

// Defines the VC SEt used by Wait On Multi Channel.
// IRS Name : VC_Set_Type
typedef unsigned short VC_Set_Type[MAX_NUMBER_OF_APOS_WOMC_VCS];

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when waiting on multiple channels.
enum WOMC_Status_Enum
{
   Wait_On_Multi_Channel_Received_OK,
   Wait_On_Multi_Channel_Timeout,
   Invalid_Wait_On_Multi_Channel_VC,
   Invalid_Wait_On_Multi_Channel_Too_Many_VCs,
   Invalid_Wait_On_Multi_Channel_Min_VCs_To_Receive,
   Invalid_Wait_On_Multi_Channel_Duplicate_VCs,
   Invalid_Wait_On_Multi_Channel_Timeout,
   Wait_On_Multi_Channel_Comms_Failure,
   Wait_On_Multi_Channel_Timer_Failure,
   Invalid_Wait_On_Multi_Channel_Param
};

typedef enum WOMC_Status_Enum WOMC_Status_Type;

// ---------------------------------------------------------------------

// Defines the time in terms of seconds and nanoseconds.
// IRS Name : Time_Type
struct Time_Struct
{
   unsigned int Seconds;
   unsigned int Nanoseconds;
};

typedef struct Time_Struct Time_Type;

// ---------------------------------------------------------------------

// Defines the status returned by the APOS procedure call when obtaining time information.
// IRS Name : Time_Status_Type
enum Time_Status_Enum
{
   Time_OK,                     // IRS Name : Time_OK
   Time_Resource_Not_Available, // IRS Name : Time_Resource_Not_Available
   Invalid_Time_Param           // IRS Name : Not Required in IRS
};

typedef enum Time_Status_Enum Time_Status_Type;

// ---------------------------------------------------------------------

enum Event_Enum
{
   Event_Timer,
   Event_Thread_Self_Exit,
   Event_Thread_Destroyed
};
typedef enum Event_Enum Event_Type;

enum WFE_Status_Enum
{
   Wait_For_Event_OK,
   Wait_For_Event_Failed,
   Wait_For_Event_Invalid_Param
};
typedef enum WFE_Status_Enum WFE_Status_Type;

// ---------------------------------------------------------------------
enum Queuing_Discipline_Enum
{
   Queuing_Discipline_FIFO,
   Queuing_Discipline_Priority
};
typedef enum Queuing_Discipline_Enum Queuing_Discipline_Type;

   // Defines the status returned from the APOS procedure when creating a semaphore.
   enum Create_Semaphore_Status_Enum
      {Create_Semaphore_OK,
       Create_Semaphore_Invalid_Semaphore_Value,
       Create_Semaphore_Invalid_Initial_Value,
       Create_Semaphore_Invalid_Max_Value,
       Create_Semaphore_Invalid_Queuing_Policy,
       Create_Semaphore_Max_Number_Of_Semaphores_Reached,
       Create_Semaphore_Invalid_Param};
typedef enum Create_Semaphore_Status_Enum Create_Semaphore_Status_Type;

   // Defines the status returned from the APOS procedure when deleting a semaphore.
   enum Delete_Semaphore_Status_Enum
      {Delete_Semaphore_OK,
       Delete_Semaphore_Invalid_Semaphore_ID,
       Delete_Semaphore_Semaphore_Busy,
       Delete_Semaphore_Invalid_Param};
typedef enum Delete_Semaphore_Status_Enum Delete_Semaphore_Status_Type;

   // Defines the status returned from the APOS procedure when waiting for a semaphore.
   enum Wait_For_Semaphore_Status_Enum
      {Wait_For_Semaphore_OK,
       Wait_For_Semaphore_Semaphore_Unavailable,
       Wait_For_Semaphore_Invalid_Semaphore_ID,
       Wait_For_Semaphore_Invalid_Timeout,
       Wait_For_Semaphore_Timer_Unavailable,
       Wait_For_Semaphore_Timeout_Expired,
       Wait_For_Semaphore_Invalid_Param};
   typedef enum Wait_For_Semaphore_Status_Enum Wait_For_Semaphore_Status_Type;

   // Defines the status returned from the APOS procedure when posting a semaphore.
   enum Post_Semaphore_Status_Enum
      {Post_Semaphore_OK,
       Post_Semaphore_Invalid_Semaphore_ID,
       Post_Semaphore_Invalid_Timer,
       Post_Semaphore_Exceeded_Semaphore_Value,
       Post_Semaphore_Invalid_Param};
   typedef enum Post_Semaphore_Status_Enum Post_Semaphore_Status_Type;

   // Defines the status returned from the APOS procedure when creating a mutex.
   enum Create_Mutex_Status_Enum
      {Create_Mutex_OK,
       Create_Mutex_Invalid_Queuing_Policy,
       Create_Mutex_Max_Number_Reached,
       Create_Mutex_Invalid_Param};
   typedef enum Create_Mutex_Status_Enum Create_Mutex_Status_Type;

   // Defines the status returned from the APOS procedure when deleting a mutex.
   enum Delete_Mutex_Status_Enum
      {Delete_Mutex_OK,
       Delete_Mutex_Invalid_ID,
       Delete_Mutex_Locked,
       Delete_Mutex_Invalid_Param};
   typedef enum Delete_Mutex_Status_Enum Delete_Mutex_Status_Type;

   // Defines the status returned from the APOS procedure when locking a mutex.
   enum Lock_Mutex_Status_Enum
      {Lock_Mutex_OK,
       Lock_Mutex_Unavailable,
       Lock_Mutex_Timeout_Expired,
       Lock_Mutex_Invalid_ID,
       Lock_Mutex_Invalid_Timeout,
       Lock_Mutex_Already_Locked,
       Lock_Mutex_Timer_Unavailable,
       Lock_Mutex_Invalid_Param};
   typedef enum Lock_Mutex_Status_Enum Lock_Mutex_Status_Type;

   // Defines the status returned from the APOS procedure when unlocking a mutex.
   enum Unlock_Mutex_Status_Enum
      {Unlock_Mutex_OK,
       Unlock_Mutex_Invalid_ID,
       Unlock_Mutex_Already_Unlocked,
       Unlock_Mutex_Not_Owner,
       Unlock_Mutex_Invalid_Timer,
       Unlock_Mutex_Invalid_Param};
   typedef enum Unlock_Mutex_Status_Enum Unlock_Mutex_Status_Type;

   //----------------------------------------------------------------------

   // Defines the scheduling policy a thread can have.
   // IRS Name : Sched_Policy_Type
   enum Sched_Policy_Enum
      {Sched_FIFO,
       Sched_RR,
       Sched_Other};
typedef enum Sched_Policy_Enum Sched_Policy_Type;

   // Defines the thread scheduling priority type.
   // IRS Name : Sched_Priority_Type
   //type Sched_Priority_Type is range 1 .. 255; //char

   // Defines the size of a thread stack.
   // IRS Name : Stack_Size_Type
   //type Stack_Size_Type is mod 2**32;
   //for Stack_Size_Type'Size use 32;

   // Defines the thread attributes.
   // IRS Name : Thread_Attr_Type
struct Thread_Attr_Struct
{
         Sched_Policy_Type Sched_Policy;
         unsigned char Sched_Priority;
         unsigned int Stack_Size;
};
typedef struct Thread_Attr_Struct Thread_Attr_Type;

   // Defines the thread ID.
   // IRS Name : Thread_ID_Type
   // type Thread_ID_Type is mod 2**32;

   // Defines the status returned from the APOS procedure when creating a thread.
   // IRS Name : Create_Thread_Status_Type
   enum Create_Thread_Status_Enum
      {Create_Thread_Call_OK,
       Create_Thread_Max_Number_Threads_Exceeded,
       Create_Thread_Out_Of_Memory,
       Create_Thread_Invalid_Policy,
       Create_Thread_Invalid_Priority,
       Create_Thread_Invalid_Stack_Size,
       Create_Thread_Invalid_Entry_Point,
       Create_Thread_Invalid_Param};
typedef enum Create_Thread_Status_Enum Create_Thread_Status_Type;

   // Defines the exit value.
   // IRS Name : Exit_Value_Type
   // type Exit_Value_Type is mod 2**32;
   // for Exit_Value_Type'Size use 32;

   enum Join_Thread_Status_Enum
      {Join_Thread_Call_OK,
       Join_Thread_Invalid_Thread_ID,
       Join_Thread_Already_Joined,
       Join_Thread_Failed,
       Join_Thread_Invalid_Param};
   typedef enum Join_Thread_Status_Enum Join_Thread_Status_Type;

   // Defines the status retuurned from the APOS procedure when destroying a thread.
   // IRS Name : Destroy_Thread_Status_Type
   enum Destroy_Thread_Status_Enum
      {Destroy_Thread_Call_OK,
       Destroy_Thread_Invalid_Thread_ID,
       Destroy_Thread_Failed,
       Destroy_Thread_Invalid_Param};
typedef enum Destroy_Thread_Status_Enum Destroy_Thread_Status_Type;

   // Defines the timeout in terms of Time_Type
   // IRS Name : Destroy_Thread_Status_Type
   typedef Time_Type Timeout_Type;

   // Defines the status returned from the APOS procedure sleep.
   // IRS Name : Sleep_Status_Type
   enum Sleep_Status_Enum
      {Sleep_Call_OK,
       Sleep_Invalid_Timeout,
       Sleep_Failed,
       Sleep_Invalid_Param};
typedef enum Sleep_Status_Enum Sleep_Status_Type;

   // Defines the status returned from the APOS procedure when obtaining scheduling parameters.
   // IRS Name : Get_Scheduling_Parameters_Status_Type
   enum Get_Scheduling_Parameters_Status_Enum
      {Get_Scheduling_Parameters_Call_OK,
       Get_Scheduling_Parameters_Invalid_Thread_ID,
       Get_Scheduling_Parameters_Invalid_Param};
typedef enum Get_Scheduling_Parameters_Status_Enum Get_Scheduling_Parameters_Status_Type;

   // Defines the status returned from the APOS procedure when setting a thread's scheduling parameters.
   // IRS Name : Set_Scheduling_Parameters_Status_Type
   enum Set_Scheduling_Parameters_Status_Enum
      {Set_Scheduling_Parameters_Call_OK,
       Set_Scheduling_Parameters_Invalid_Thread_ID,
       Set_Scheduling_Parameters_Invalid_Policy,
       Set_Scheduling_Parameters_Invalid_Priority,
       Set_Scheduling_Parameters_Failed,
       Set_Scheduling_Parameters_Invalid_Param};
typedef enum Set_Scheduling_Parameters_Status_Enum Set_Scheduling_Parameters_Status_Type;

   // Defines the status returned from the APOS procedure when setting a thread's priority.
   // IRS Name : Set_Scheduling_Priority_Status_Type
   enum Set_Scheduling_Priority_Status_Enum
      {Set_Scheduling_Priority_Call_OK,
       Set_Scheduling_Priority_Invalid_Thread_ID,
       Set_Scheduling_Priority_Invalid_Priority,
       Set_Scheduling_Priority_Failed,
       Set_Scheduling_Priority_Invalid_Param};
typedef enum Set_Scheduling_Priority_Status_Enum Set_Scheduling_Priority_Status_Type;

// ------------------------------------------------------------------------

// Defines the status returned from the APOS procedure when creating a semaphore.
enum Create_Timer_Status_Enum
   {Create_Timer_OK,
    Create_Timer_Invalid_Time,
    Create_Timer_Resource_Not_Available,
    Invalid_Create_Timer_Param};
typedef enum Create_Timer_Status_Enum Create_Timer_Status_Type;

// Defines the status returned from the APOS procedure when creating a semaphore.
enum Start_Timer_Status_Enum
   {Start_Timer_OK,
    Start_Timer_Already_Running,
    Start_Timer_Invalid_Timer,
    Start_Timer_Failed,
    Invalid_Start_Timer_Param};
typedef enum Start_Timer_Status_Enum Start_Timer_Status_Type;

// Defines the status returned from the APOS procedure when stopping a timer.
enum Stop_Timer_Status_Enum
   {Stop_Timer_OK,
    Stop_Timer_Already_Stopped,
    Stop_Timer_Invalid_Timer,
    Stop_Timer_Failed,
    Invalid_Stop_Timer_Param};
typedef enum Stop_Timer_Status_Enum Stop_Timer_Status_Type;

// Defines the status returned from the APOS procedure when stopping a timer.
enum Delete_Timer_Status_Enum
   {Delete_Timer_OK,
    Delete_Timer_Still_Running,
    Delete_Timer_Invalid_Timer,
    Invalid_Delete_Timer_Param};
typedef enum Delete_Timer_Status_Enum Delete_Timer_Status_Type;

#endif
