// ----------------------------------------------------------------------
// This is an unpublished work created in 2010, any copyright in which
// vests in BAE SYSTEMS. All rights reserved. The information contained
// in this record is proprietary to BAE SYSTEMS unless stated otherwise
// and is made available in confidence; it must not be used or disclosed
// without the express written consent of BAE SYSTEMS which may be given
// by contract.
//
// Department : IMS OSL Project,
//              Hawk Mission Systems,
//              Brough,
//              East Yorkshire,
//              England,
//              HU15 1EQ
//
// Revision History :
//
// Date       Author          Description
// ----       ------          -----------
// 11/10/04   J.R.Stones      Original version.
// 12/07/06   P.R.Miller      BAE-BSY-RM-HWK-005103: correcting coding
//                            standards non-conformance issues.
// 30/11/10   D.Clarke        Added consts used by mass store.
// 22/07/11   J.Hudson        BAE-BSY-PR-IMS-122: added Wait_On_Multi_Channel
//                            service.
// 13/02/13   M.Ward          BAE-BSY-PR-IMS-210: Increased value of
//                            MAX_LENGTH_OF_LOG_ENTRY
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
//
// Compile_Constants
//
// Purpose :
//    The Compile_Constants defines the list of compile constants, which
//    are related to a particular system. This avoids the duplication of
//    the definition of these constants and allows changes to be scoped
//    to one package, so that consistency is achieved across the system.
//
//    This file is a copy of its Ada95 duplicate, with the exception
//    that only those compile constants required for the C implementation
//    of the APOS interface are specified. This values conform to those
//    specified in BAE-BSY-RP-HWK-001726.
//
// Effects :
//    This package is used to constrain the type declarations used
//    within a particular system.
//
// Performance :
//    Not applicable.
//
// Safety-Criticality :
//    This software is implemented to Safety Integrity Level 3.
//
// ---------------------------------------------------------------------

#ifndef COMPILE_CONSTANTS_INCLUDED
#define COMPILE_CONSTANTS_INCLUDED

// ---------------------------------------------------------------------

// Defines the maximum length of a log entry.
#define MAX_LENGTH_OF_LOG_ENTRY 42

// Defines the maximum number of VCs in VC sets in Wait_On_Multi_Channel
#define MAX_NUMBER_OF_WOMC_VCS 6
// ---------------------------------------------------------------------

// The following are constants used by the Mass Store

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define O_RDONLY  0x0000
#define O_WRONLY  0x0001
#define O_RDWR    0x0002
#define O_CREAT   0x0200
#define O_APPEND  0x0008
#define O_TRUNC   0x0400
#define O_EXCL    0x0800
//#define O_NONBLOCK  0x4000   // Not yet supported

// ---------------------------------------------------------------------
#endif
