// ---------------------------------------------------------------------
// This is an unpublished work created in 2004, any copyright in which
// vests in BAE SYSTEMS. All rights reserved. The information contained
// in this record is proprietary to BAE SYSTEMS unless stated otherwise
// and is made available in confidence; it must not be used or disclosed
// without the express written consent of BAE SYSTEMS which may be given
// by contract.
//
// Department : Software Architectures Team,
//              Mission Systems,
//              Brough,
//              East Yorkshire,
//              England,
//              HU15 1EQ
//
// Revision History :
//
// Date       Author          Description
// ----       ------          -----------
// 11/10/04   J.R.Stones      Original version.
// 11/05/07   P.Moxon         Moved declarations around.
// 10/07/07   P.Moxon         Added Get_Absolute_Global_Time.
// 09/11/10   K.Jones         Added Cap 3 functionality.
// 30/11/10   D.Clarke        Added Mass Store Services.
// 22/02/11   D.Clarke        BAE_BSY_PR_IMS_86: Added Get_Relative_Local_Time.
// 05/04/11   P.R.Miller      BAE-BSY-PR-IMS-80: Added service
//                            Wait_For_Event.
// 22/07/11   J.Hudson        BAE-BSY-PR-IMS-122: added Wait_On_Multi_Channel
//                            service and
//                            BAE-BSY-PR-IMS-123: Errors in C/C++ bindings.
// 23/08/11   R.Payne         BAE-BSY-PR-IMS-133: added missing timer procedures
// 26/09/13   D.Clarke        BAE-BSY-PR-IMS-341: Changed name of size_t
//                            and ssize_t.
// 22/01/15   P.R.Miller      BAE-BSY-PR-IMS-576: Updated from IMS
//                            Capabilty 3 to include Capability 4
//                            functionality - removed file services.
// 08/06/16   P.R.Miller      BAE-BSY-PR-IMS-648: Added four new APOS
//                            services for dealing with Mutexes and
//                            Create_Absolute_Local_Timer.
// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
//
// APOS
//
// Purpose :
//    This defines the operations required for the APOS.
//
// Effects :
//    None.
//
// Performance :
//    Not applicable.
//
// Safety-Criticality :
//    This software is implemented to Safety Integrity Level 3.
//
// ---------------------------------------------------------------------

#ifndef APOS_INCLUDED
#define APOS_INCLUDED

// ---------------------------------------------------------------------

#include "osl004_apos_types.h"

// Not sure we should change the apos.h really, but it's not necessarily and an issue,
// as long as the code generator only generates calls to these functions if POSIX (not "real" IMS)
void setup_signal_handler();
int Scale_ThreadPriority(unsigned char Thread_Priority, int Sched_Policy);


// =====================================================================
// COMMUNICATION SERVICES
//    These services allow a process to send and receive data using
//    virtual channels. Services are provided for both blocking and
//    non-blocking mechanisms.
// =====================================================================

// ---------------------------------------------------------------------
//
// Send_Message_Non_Blocking
//
// Purpose :
//    This service sends data on a virtual channel.
//
// ---------------------------------------------------------------------

void Send_Message_Non_Blocking
   (int              VC_ID,
    void             *Msg_Buffer,
    int              Msg_Length,
    SMNB_Status_Type *Status);

// ---------------------------------------------------------------------
// Send_Message
// ---------------------------------------------------------------------

void Send_Message
   (int              VC_ID,
    void             *Msg_Buffer,
    int              Msg_Length,
    Time_Type        Timeout,
    SM_Status_Type   *Status);

// ---------------------------------------------------------------------
//
// Receive_Message_Non_Blocking
//
// Purpose :
//    This service receives data on a virtual channel without
//    waiting for it to arrive.
//
// ---------------------------------------------------------------------
extern
void Receive_Message_Non_Blocking
   (int              VC_ID,
    void             *Msg_Buffer,
    int              Msg_Length_Available,
    int              *Msg_Length,
    RMNB_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Receive_Message
//
// Purpose :
//    This service receives data on a virtual channel waiting for the
//    specified timeout period if no data is available initially.
//
//
// ---------------------------------------------------------------------

void Receive_Message
   (int            VC_ID,
    void           *Msg_Buffer,
    int            Msg_Length_Available,
    Time_Type      Timeout,
    int            *Msg_Length,
    RM_Status_Type *Status);


// ---------------------------------------------------------------------
// Wait_On_Multi_Channel
//
// Purpose :
//    This service waits on multiple virtual channels, waiting for the
//    specified timeout period if no data is available initially.
// ---------------------------------------------------------------------

void Wait_On_Multi_Channel
   (VC_Set_Type      VC_Set_In,
    int              Min_VCs_To_Receive,
    Time_Type        Timeout,
    VC_Set_Type      *VC_Set_Out,
    WOMC_Status_Type *Status);

// =====================================================================
// TIME SERVICES
//    These services allow a process to access time references.
// =====================================================================

// ---------------------------------------------------------------------
//
// Get_Absolute_Local_Time
//
// Purpose :
//    This service returns the current local time relative to system
//    power-up.
//
// ---------------------------------------------------------------------

void Get_Absolute_Local_Time
   (Time_Type        *Time,
    Time_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Get_Relative_Local_Time
//
// Purpose :
//    This service returns the current local time relative to module
//    power-up.
//
// ---------------------------------------------------------------------

void Get_Relative_Local_Time
   (Time_Type        *Time,
    Time_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Get_Absolute_Global_Time
//
// Purpose :
//    This service returns the current global time external to system
//
// ---------------------------------------------------------------------

void Get_Absolute_Global_Time
   (Time_Type        *Time,
    Time_Status_Type *Status);

// =====================================================================
// SCHEDULING SERVICES
//    These services allow a process to de-schedule itself
//    and hand back control to the scheduler.
// =====================================================================

// ---------------------------------------------------------------------
//
// Suspend_Self
//
// Purpose :
//    This service allows a process to voluntarily suspend itself
//    and to hand back control to the scheduler through the MSL
//    context control mechanisms.
//
// ---------------------------------------------------------------------

void Suspend_Self
   ();

// =====================================================================
// ERROR HANDLING SERVICES
//    These services allow a process to inform the OSL of an error that
//    needs to be handled and to inform the OSL of an error that needs
//    only to be logged.
// =====================================================================

// ---------------------------------------------------------------------
//
// Raise_Application_Error
//
// Purpose :
//    This service allows a process error to be reported to the OSL
//    for handling.
//
// ---------------------------------------------------------------------

void Raise_Application_Error
   (int             Code,
    Log_Entry_Type  Log_Entry,
    RAE_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Log_Error
//
// Purpose :
//    This service allows a process error to be reported to the OSL
//    for logging.
//
// ---------------------------------------------------------------------

void Log_Error
   (Log_Entry_Type Log_Entry,
    LE_Status_Type *Status);

// =====================================================================
// EVENT HANDLING SERVICES
//    These services allow a thread to perform event handling.
// =====================================================================

// ----------------------------------------------------------------------
//
//  Wait_For_Event
//
//  Purpose :
//     This service allows the caller to wait for an event to occur. Only
//     one thread can block at anyone time waiting for events so
//     subsequent calls to this service will result in an error.
//
// ----------------------------------------------------------------------
void Wait_For_Event
   (Event_Type      *Event,
    unsigned int    *Event_Info,
    WFE_Status_Type *Status);

// =====================================================================
// SYNCHRONISATION SERVICES
//    These services allow a thread to perform synchronisation through
//    the use of semaphores.
// =====================================================================

//----------------------------------------------------------------------
//
// Create_Semaphore
//
// Purpose :
//    This service allows the caller to create a semaphore.
//
//----------------------------------------------------------------------
void Create_Semaphore
 (int Init_Value,
  int Max_Value,
  Queuing_Discipline_Type Queuing_Discipline,
  int *Semaphore_ID,
  Create_Semaphore_Status_Type *Status);

//----------------------------------------------------------------------
//
// Delete_Semaphore
//
// Purpose :
//    This service allows the caller to delete the identified semaphore.
//
//----------------------------------------------------------------------
void Delete_Semaphore
 (int Semaphore_ID,
  Delete_Semaphore_Status_Type *Status);

//----------------------------------------------------------------------
//
// Wait_For_Semaphore
//
// Purpose :
//    This service allows the caller to wait on the identified
//    semaphore.
//
//----------------------------------------------------------------------
void Wait_For_Semaphore
 (int Semaphore_ID,
  Time_Type *Timeout,
  Wait_For_Semaphore_Status_Type *Status);

//----------------------------------------------------------------------
//
// Post_Semaphore
//
// Purpose :
//    This service allows the caller to post the identified semaphore.
//
//----------------------------------------------------------------------
void Post_Semaphore
 (int Semaphore_ID,
  Post_Semaphore_Status_Type *Status);

//----------------------------------------------------------------------
//
// Create_Mutex
//
// Purpose :
//    This service allows the caller to create a mutex.
//
//----------------------------------------------------------------------
void Create_Mutex
 (Queuing_Discipline_Type Queuing_Discipline,
  int *Mutex_ID,
  Create_Mutex_Status_Type *Status);

//----------------------------------------------------------------------
//
// Delete_Mutex
//
// Purpose :
//    This service allows the caller to delete the identified mutex.
//
//----------------------------------------------------------------------
void Delete_Mutex
 (int Mutex_ID,
  Delete_Mutex_Status_Type *Status);

//----------------------------------------------------------------------
//
// Lock_Mutex
//
// Purpose :
//    This service allows the caller to lock the identified mutex. The
//    caller will block if the mutex is not available and an appropriate
//    Timerout value is given.
//
//----------------------------------------------------------------------
void Lock_Mutex
 (int Mutex_ID,
  Time_Type *Timeout,
  Lock_Mutex_Status_Type *Status);

//----------------------------------------------------------------------
//
// Unlock_Mutex
//
// Purpose :
//    This service allows the caller to unlock the identified mutex.
//
//----------------------------------------------------------------------
void Unlock_Mutex
 (int Mutex_ID,
  Unlock_Mutex_Status_Type *Status);

// =====================================================================
// THREAD SERVICES
//    These services allow for the creation, deletion and management of
//    threads.
// =====================================================================

//----------------------------------------------------------------------
//
// Create_Thread
//
// Purpose :
//    This service allows the caller to create a thread within a
//    process.
//
//----------------------------------------------------------------------
void Create_Thread
 (Thread_Attr_Type *Thread_Attr,
  void *Entry_Point,
  void *Argument,
  int *Thread_ID,
  Create_Thread_Status_Type *Status);

//----------------------------------------------------------------------
//
// Exit_Thread
//
// Purpose :
//    This service terminates the calling thread.
//
//----------------------------------------------------------------------
void Exit_Thread
 (int Termination_Value);

//----------------------------------------------------------------------
//
// Destroy_Thread
//
// Purpose :
//    This service allows the caller to destroy the identified thread.
//
//----------------------------------------------------------------------
void Destroy_Thread
 (int Thread_ID,
  Destroy_Thread_Status_Type *Status);

//----------------------------------------------------------------------
//
// Yield_Thread
//
// Purpose :
//    This service allows the callling thread to relinquish the processor
//    until it is eligible to schedule again.
//
//----------------------------------------------------------------------
void Yield_Thread(void);

//----------------------------------------------------------------------
//
// Join_Thread
//
// Purpose :
//    This service allows the calling thread to relinquish the processor
//    until the identified thread exits.
//
//----------------------------------------------------------------------
void Join_Thread
 (int Thread_ID,
  int *Exit_Value,
  Join_Thread_Status_Type *Status);

//----------------------------------------------------------------------
//
// Sleep
//
// Purpose :
//    This service allows the caller to destroy the identified thread.
//
//----------------------------------------------------------------------
void Sleep
 (Timeout_Type *Timeout,
  Sleep_Status_Type *Status);

//----------------------------------------------------------------------
//
// Get_Scheduling_Parameters
//
// Purpose :
//    This service allows the caller to retrieve scheduling details for
//    the identified thread.
//
//----------------------------------------------------------------------
void Get_Scheduling_Parameters
 (int Thread_ID,
  Sched_Policy_Type *Policy,
  unsigned char *Priority,
  Get_Scheduling_Parameters_Status_Type *Status);

//----------------------------------------------------------------------
//
// Set_Scheduling_Parameters
//
// Purpose :
//    This service allows the caller to set scheduling details for the
//    identified thread.
//
//----------------------------------------------------------------------
void Set_Scheduling_Parameters
 (int Thread_ID,
  Sched_Policy_Type Policy,
  unsigned char Priority,
  Set_Scheduling_Parameters_Status_Type *Status);

//----------------------------------------------------------------------
//
// Set_Scheduling_Priority
//
// Purpose :
//    This service allows the caller to set the priority for the
//    identified thread.
//
//----------------------------------------------------------------------
void Set_Scheduling_Priority
 (int Thread_ID,
  unsigned char Priority,
  Set_Scheduling_Priority_Status_Type *Status);

//----------------------------------------------------------------------
//
// Get_My_Thread_ID
//
// Purpose :
//    This service allows the caller to get their thread ID.
//
//----------------------------------------------------------------------
int Get_My_Thread_ID();

// ---------------------------------------------------------------------

// ---------------------------------------------------------------------
//
// Create_Timer
//
// Purpose :
//    This service will create a timer.
//
// ---------------------------------------------------------------------
void Create_Timer
   (Time_Type                Time,
    int                      *Timer_ID,
    Create_Timer_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Create_Absolute_Local_Timer
//
// Purpose :
//    This service will create a timer that terminates at the requested
//    absolute local time.
//
// ---------------------------------------------------------------------
void Create_Absolute_Local_Timer
   (Time_Type                Time,
    int                      *Timer_ID,
    Create_Timer_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Start_Timer
//
// Purpose :
//    This service starts the specified timer.
//
// ---------------------------------------------------------------------
void Start_Timer
   (int                      Timer_ID,
    Start_Timer_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Stop_Timer
//
// Purpose :
//    This service stops the specified timer.
//
// ---------------------------------------------------------------------
void Stop_Timer
   (int                     Timer_ID,
    Stop_Timer_Status_Type *Status);

// ---------------------------------------------------------------------
//
// Delete_Timer
//
// Purpose :
//    This service deletes the specified timer.
//
// ---------------------------------------------------------------------
void Delete_Timer
   (int                      Timer_ID,
    Delete_Timer_Status_Type *Status);

#endif
